/*
 * tools/lib/vg_check_name.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * December 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */


#include <liblvm.h>

int vg_check_dir ( char *vg_name) {
   int length = 0;
   int ret = FALSE;
   struct stat stat_buf;
   char vg_name_buf[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_check_dir -- CALLED\n");
#endif

   if ( vg_name == NULL) return -LVM_EPARAM;

#ifdef DEBUG
   debug ( "vg_check_dir -- vg_name: \"%s\"\n", vg_name);
#endif

   length = strlen ( LVM_DIR_PREFIX);
   if ( strncmp ( vg_name, LVM_DIR_PREFIX, length) != 0)
      sprintf ( vg_name_buf, "%s%s%c", LVM_DIR_PREFIX, vg_name, 0);

   if ( stat ( vg_name_buf, &stat_buf) != -1) ret = TRUE;

#ifdef DEBUG
   debug ( "vg_check_dir -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
